result = sys.msgbox("ntScrubber Starting!", "ntScrubber", MB_TYPEOKCANCEL, MB_ICONEXCLAMATION)
if result == "cancel" then
      print("User Cancelled")
      sys.msgbox("ntScrubber Cancelled!", "ntScrubber", MB_TYPEOK, MB_ICONEXCLAMATION)
      os.exit(1)
end

os_ver = sys.os()
spool_processor_dir = "w32x86"
if string.match(os_ver.processor, "x32") then
   spool_processor_dir = "w32x86"
   print("Detected x32 OS")
else
   if string.match(os_ver.processor, "x64") then
      spool_processor_dir = "x64"
      print("Detected x64 OS")
   else
      print("Unsupported OS")
      os.exit(1)
   end
end

device_enumerator_list = 
{
  "USBPRINT\\Hewlett-PackardHP_LaC085",
  "USBPRINT\\Hewlett-PackardHP_LaC1C5",
  "USBPRINT\\Hewlett-PackardHP_La0104",
  "USBPRINT\\Hewlett-PackardHP_La0384",
  "USBPRINT\\Hewlett-PackardHP_La02C4",
  "USBPRINT\\Hewlett-PackardHP_LaC645",
  "USBPRINT\\Hewlett-PackardHP_La84FE",
  "USBPRINT\\Hewlett-PackardHP_La454F",
  "USBPRINT\\Hewlett-PackardHP_La45BF",
  "USBPRINT\\Hewlett-PackardHP_La85EE",
  "USBPRINT\\Hewlett-PackardHP_La86DE",
  "USBPRINT\\Hewlett-PackardHP_LaserJet_CP1025nw",
 
  "USBSTOR\\CdRom&Ven_HP&Prod_Smart_Install&Rev_1.0",
 
  "USB\\Vid_03f0&Pid_112A",
  "USB\\Vid_03f0&Pid_0B2A",
  "USB\\VID_03F0&PID_0B2A&MI_00",
  "USB\\VID_03F0&PID_0B2A&MI_01",
}

printer_driver_list = 
{
  "HP LaserJet Professional CP1021",
  "HP LaserJet Professional CP1022",
  "HP LaserJet Professional CP1023",
  "HP LaserJet Professional CP1025",
  "HP LaserJet Professional CP1026",
  "HP LaserJet Professional CP1028",
  "HP LaserJet Professional CP1022nw",
  "HP LaserJet Professional CP1025nw",
  "HP LaserJet Professional CP1026nw",
  "HP LaserJet Professional CP1027nw",
  "HP LaserJet Professional CP1028nw",
}

print_processor_list = 
{
--  "HPM1210PrintProc",
}

print_monitor_list = 
{
--  "HPM1210LM",
}

oem_inf_section_list = 
{
--  "HPM1130",
--  "HPM1210",
}

-- CSIDL_SYSTEM        = C:\Windows\System32
-- CSIDL_WINDOWS       = C:\Windows
-- CSIDL_PROGRAM_FILES = C:\Program Files
-- spool_processor_dir = w32x86 or x64
filepath_cleanup_list =
{
  string.format("%s\\spool\\drivers\\%s\\3\\HPCP1020.chm",   sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\HPCP1020GC.DLL", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\HPCP1020LM.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\HPCP1020PP.DLL", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\HPCP1020PQ.DLL", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\HPCP1020SD.DLL", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\HPCP1020SD.SDD", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\HPCP1020SU.DLL", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\HPCP1020SU.ent", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\HPCP1020SU.VER", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\hppccompio.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),
  string.format("%s\\spool\\drivers\\%s\\3\\hppdcompio.dll", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),

  string.format("%s\\spool\\prtprocs\\%s\\HPCP1020PP.DLL", sys.folderpath(CSIDL_SYSTEM), spool_processor_dir),

  string.format("%s\\hpbcoins32.dll", sys.folderpath(CSIDL_SYSTEM)),
  string.format("%s\\hpbcoins64.dll", sys.folderpath(CSIDL_SYSTEM)),
  string.format("%s\\HPCP1020LM.dll", sys.folderpath(CSIDL_SYSTEM)),
  string.format("%s\\hppccompio.dll", sys.folderpath(CSIDL_SYSTEM)),
  string.format("%s\\hppdcompio.dll", sys.folderpath(CSIDL_SYSTEM)),
  string.format("%s\\hpmldm01.dll",   sys.folderpath(CSIDL_SYSTEM)),
  string.format("%s\\hpmldm02.dll",   sys.folderpath(CSIDL_SYSTEM)),

  string.format("%s\\drivers\\hppcbulkio.sys", sys.folderpath(CSIDL_SYSTEM)),
  string.format("%s\\drivers\\hppdbulkio.sys", sys.folderpath(CSIDL_SYSTEM)),
  string.format("%s\\drivers\\hppcgenio.sys",  sys.folderpath(CSIDL_SYSTEM)),
  string.format("%s\\drivers\\hppdgenio.sys",  sys.folderpath(CSIDL_SYSTEM)),

  string.format("%s\\hppcompiocomm.dll",       sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\multiflexio.dll",         sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\multiflexio-plugins.xml", sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\multiflexio-plugins.xsd", sys.folderpath(CSIDL_WINDOWS)),
  string.format("%s\\netcomm.dll",             sys.folderpath(CSIDL_WINDOWS)),
}

folderpath_cleanup_list =
{
  string.format("%s\\HP\\HP LaserJet Professional CP1020 Series", sys.folderpath(CSIDL_PROGRAM_FILES)),
}

registry_cleanup_list =
{
  HKEY_LOCAL_MACHINE, "SOFTWARE\\HP\\HPCP1020",
  HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\HP LaserJet Professional CP1020 Series",
}

--
-- turn on verbose messaging
--
verbose(true)

--
-- Uninstall HP LaserJet Professional CP1020 Series Software
--
print(string.format("Attempt to run HP LaserJet CP1020 Series Software Uninstaller"))
commandline = string.format("%s\\HP\\HP LaserJet Professional CP1020 Series\\UnInstall.exe", sys.folderpath(CSIDL_PROGRAM_FILES))
print(string.format("Running CP1020 Series Software Uninstaller = %s", commandline))
if (sys.exist(commandline)) then
   proc.execute(commandline)
   print(string.format("Waiting for UnInstall.exe to complete..."))
   while (proc.pid("UnInstall.exe") > 0) do
      sys.wait(1000)      
   end
else
   print(string.format("  **Could not find %s", commandline))
end

--
-- Stop HPSIP1100Service
--
print("Stopping HP SI Service")
if service.stop("HP SI Service", 15000) == 0 then
  print("  **Failed to stop HP SI Service**")
end

--
-- Delete HP SI Service
--
print("Deleting HP SI Service")
if service.delete("HP SI Service") == 0 then
  print("  **Failed to delete HP SI Service**")
end

--
-- Stop Spooler
--
print("Stopping spooler")
if service.stop("Spooler", 15000) == 0 then
  print("  **Failed to stop spooler**")
end

--
-- Uninstall Driver Package
--
infpath = string.format("%s\\HP\\HP LaserJet Professional CP1020 Series\\CP1020.INF", sys.folderpath(CSIDL_PROGRAM_FILES))
print(string.format("Attempt to Uninstall Driver Package for: %s", infpath))
if device.dpuninst(infpath) == 0 then
  print(string.format("  **Failed to uninstall driver package**"))
end

--
-- Remove Device(s)
--
function func_remove_devices(enumName)
  print(string.format("Removing devices with enumerator = %s", enumName))
  if device.pnpremove(enumName, true, true) == 0 then
    print("  **Failed to remove all devices**")
  end
end

i=1
while (i <= #device_enumerator_list) do
  func_remove_devices(device_enumerator_list[i])
  i = i + 1
end

--
-- Remove any dangling OEM INFs
--
function oeminf_files(filename, status)
  if (status == 0) then
    i=1
    while (i <= #oem_inf_section_list) do
      if (device.infisvalid(filename, oem_inf_section_list[i]) == 1) then
        print(string.format("Removing device INF file = %s", filename))
        if (device.infremove(filename, oem_inf_section_list[i]) == 0) then
          print("  **Failed to remove device INF file**")
        end
      end
      i = i + 1
    end
  end

  return 1
end

-- IS IT OK TO REMOVE ALL oem*.inf FILES?
print(string.format("Attempting to remove any dangling OEM INFs"))
wininfdir = string.format("%s\\inf",sys.windir())
sys.forfiles(wininfdir, "oem*.inf", 0, oeminf_files)

--
-- Start Spooler
--
print("Starting spooler")
if service.start("Spooler", 15000) == 0 then
  print("  **Failed to start spooler**")
end

--
-- Remove Printer(s)
--
function func_remove_printers(driverName)
  print(string.format("Removing printers using driver = %s", driverName))
  if printer.removeprinters(driverName) == 0 then
    print("  **Failed to remove all printers**")
  end
end

i=1
while (i <= #printer_driver_list) do
  func_remove_printers(printer_driver_list[i])
  i = i + 1
end

--
-- Remove Printer Driver(s)
--
function func_remove_drivers(driverName)
  print(string.format("Removing printer driver = %s", driverName))
  if printer.removedrivers(driverName) == 0 then
    print("  **Failed to remove printer driver**")
  end
end

i=1
while (i <= #printer_driver_list) do
  func_remove_drivers(printer_driver_list[i])
  i = i + 1
end

--
-- Remove Print Processor(s)
--
function func_remove_processors(processorName)
  print(string.format("Removing print processor = %s", processorName))
  if printer.removeprintprocessors(processorName) == 0 then
    print("  **Failed to remove print processor**")
  end
end

i=1
while (i <= #print_processor_list) do
  func_remove_processors(print_processor_list[i])
  i = i + 1
end

--
-- Remove Print Monitor(s)
--
function func_remove_monitors(monitorName)
  print(string.format("Removing monitor = %s", monitorName))
  if printer.removemonitors(monitorName) == 0 then
    print("  **Failed to remove monitor**")
  end
end

i=1
while (i <= #print_monitor_list) do
  func_remove_monitors(print_monitor_list[i])
  i = i + 1
end

--
-- Stop Spooler
--
print("Stopping spooler")
if service.stop("Spooler", 15000) == 0 then
  print("  **Failed to stop spooler**")
end

--
-- Cleanup files in list filepath list
--
i=1
while (i <= (#filepath_cleanup_list)) do
  fullpath = filepath_cleanup_list[i]
  print(string.format("Removing file path = %s", fullpath))
  sys.del(fullpath)
  i = i + 1
end

--
-- Cleanup folderpath directorys in list
--
i=1
while (i <= (#folderpath_cleanup_list)) do
  fullpath = folderpath_cleanup_list[i]
  print(string.format("Removing directory tree = %s", fullpath))
  sys.deltree(fullpath)
  i = i + 1
end

--
-- Cleanup registry key paths in list
--
i=1
while (i <= (#registry_cleanup_list-1)) do
  key = registry_cleanup_list[i]
  keypath = tostring(registry_cleanup_list[i+1])
  print(string.format("Removing registry key = %s\\%s", reg.strhkey(key), keypath))
  reg.deletetree(key, keypath)
  i = i + 2
end

--
-- Start Spooler
--
print("Starting spooler")
if service.start("Spooler", 15000) == 0 then
  print("  **Failed to start spooler**")
end

--
-- Notify complete
--
result = sys.msgbox("ntScrubber Completed!\n\nReboot is required.", "ntScrubber", MB_TYPEOKCANCEL, MB_ICONEXCLAMATION)
if result == "ok" then
   sys.shutdown(10, false, true)
end

